(function($, Drupal) {

  Drupal.behaviors.newsBlock = {
    attach(context) {
      const elements = once('newsBlockBehavior', 'html', context);
      elements.forEach(function (){

          function camelCase(str) {
            return str.replace(/-([a-z])/g, function (g) {
              return g[1].toUpperCase();
            });
          }
          // Initialize Owl Carousel after loading
          var $ = jQuery.noConflict();
          $('.carousel-elements').owlCarousel({
            loop: false,
            margin: 20,
            nav: true,
            responsive: {
              0: {
                items: 1.5,
              },
              600: {
                items: 2.5,
              },
              1000: {
                items: 2.5,
              },
            },
          });
      });
    },
  };

})(jQuery, Drupal);
