(function (Drupal, $) {

  Drupal.behaviors.categoriesBlock = {
    attach(context) {

      // Vérifier si nous sommes sur la page qui charge dynamiquement body.html
      if ($("#content-container").length > 0) {
        // Charger dynamiquement le contenu de body.html
        $("#content-container").load("body.html", function () {
          console.log("Contenu de body.html chargé dynamiquement");
          // Une fois le contenu chargé, initialiser les fonctionnalités spécifiques
          initializeBodyContent();
        });
      } else {
        // Si nous sommes directement sur body.html, initialiser les fonctionnalités
        initializeBodyContent();
      }
    },
  };




  // Initialisation du contenu principal (body.html)
  function initializeBodyContent() {
    console.log("Initialisation du contenu body");
    const CONFIG = {
      logoImages: {
        groupA: "/images/imgbody/imgsection4/maxis_javela.png",
        groupB: "/images/imgbody/imgsection4/maxis_javelb.png"
      }
    };
    // Vérifier si la section4 existe
    if ($(".section-marque").length === 0) {
      console.log("Section4 non trouvée, arrêt de l'initialisation du body");
      return;
    }

    console.log("Section4 trouvée, initialisation en cours...");

    const $section4 = $(".section-marque");
    const $section4New = $(".section4-new");
    const $sectionPetite = $(".section-petite");

    // Handle resize events
    let resizeTimer;
    $(window).on('resize', function () {
      clearTimeout(resizeTimer);
      resizeTimer = setTimeout(handleResize, 250);
    });

    function handleResize() {
      const windowWidth = $(window).width();
      adjustLayout(windowWidth);
    }

    function adjustLayout(windowWidth) {
      const layoutClasses = {
        mobile: windowWidth <= 768,
        tablet: windowWidth > 768 && windowWidth <= 1024
      };

      updateLayoutClasses(layoutClasses);
      adjustImageSizes(layoutClasses);
    }

    function updateLayoutClasses({
      mobile,
      tablet
    }) {
      $('.content-container')
        .toggleClass('mobile-layout', mobile)
        .toggleClass('tablet-layout', tablet);

      $('.images-container')
        .toggleClass('mobile-images', mobile)
        .toggleClass('tablet-images', tablet);

      $('.text-content')
        .toggleClass('mobile-text', mobile)
        .toggleClass('tablet-text', tablet);
    }

    function adjustImageSizes({
      mobile,
      tablet
    }) {
      // Votre code pour ajuster les tailles d'images ici
    }

    function displayContent(imageNumber) {
      const $originalImage = $(`#image${imageNumber}`);
      console.log($originalImage)
      if ($originalImage.length === 0) {
        console.error(`Image #image${imageNumber} non trouvée`);
        return;
      }

      const content = $originalImage.parent().find('.content').html();
      const caption = $originalImage.siblings('p').text();
      const marque_name = $originalImage.siblings('.marque-name').text();
      const imageSrc = $originalImage.attr('src');
      const logoSrc = $originalImage.parent().siblings('.image-marque').find('img').attr('src');
      console.log(marque_name)
      transitionToNewContent($originalImage, {
        content,
        marque_name,
        imageSrc,
        logoSrc
      });
    }

    function getLogoSource($image) {
      const logoType = $image.data('logo-type');
      return CONFIG.logoImages[logoType];
    }

    function transitionToNewContent($originalImage, {
      content,
      marque_name,
      imageSrc,
      logoSrc
    }) {
      $section4.fadeOut(300, () => {
        $section4New.add($sectionPetite).fadeIn(300);

        updateNewSectionContent({
          content,
          marque_name,
          imageSrc,
          logoSrc
        });

        handleResize();
        scrollToNewSection();
      });
    }

    function updateNewSectionContent({
      content,
      marque_name,
      imageSrc,
      logoSrc
    }) {
      const $section4New = $('.section4-new');
      $section4New.find('.logo-image').attr('src', logoSrc);
      $section4New.find('.product-image').attr('src', imageSrc);
      $section4New.find('.product-title').text(marque_name);
      $section4New.find('.product-description').html(content);
    }

    function InitialiseNewSectionContent() {
      const $section4New = $('.section4-new');
      $section4New.find('.logo-image').attr('src', '');
      $section4New.find('.product-image').attr('src', '');
      $section4New.find('.product-title').text('');
      $section4New.find('.product-description').html('');
    }

    function scrollToNewSection() {
      const offset = $(window).width() <= 768 ? 50 : 100;
      $('html, body').animate({
        scrollTop: $section4New.offset().top - offset
      }, 400);
    }

    // Initialisation des gestionnaires d'événements
    $section4.on('click', 'img', function () {
      console.log("Image clicked in section4");
      const imageNumber = this.id.replace('image', '');
      displayContent(imageNumber);
    });

    // Initialisation des images défilantes
    initializeScrollImages();

    function initializeScrollImages() {
      $section4.find('.carte img').each((index, img) => {
        $("<img>")
          .attr({
            'src': img.src,
            'data-image-number': index,
            'class': 'scroll-image'
          })
          .appendTo(".scroll-images-container");
      });
    }

    // Gestion des clics sur les images défilantes
    $(".scroll-images-container").on('click', '.scroll-image', function () {
      InitialiseNewSectionContent();
      displayContent($(this).data('image-number'));
    });

    // Initialisation du layout
    handleResize();
    console.log("Initialisation du body complète");
  }




})(Drupal, jQuery);
