const path = require('path');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');
const glob = require('glob');

module.exports = {
  mode: 'development', // Utilise 'production' pour la version finale
  entry: () => {
    const files = glob.sync('./components/**/*.scss');
    if (files.length === 0) {
      throw new Error('Aucun fichier .scss trouvé');
    }
    // Création d'un objet d'entrée basé sur les fichiers SCSS trouvés
    return files.reduce((acc, file) => {
      const name = path.relative(__dirname, file); // Utilise le chemin relatif
      acc[name] = file; // Ajoute chaque fichier .scss en entrée
      return acc;
    }, {});
  },
  output: {
    path: path.resolve(__dirname, './'), 
    filename: '[name].js',
  },
  module: {
    rules: [
      {
        test: /\.scss$/,
        use: [
          MiniCssExtractPlugin.loader,
          'css-loader',
          'sass-loader',
        ],
      },
    ],
  },
  plugins: [
    new MiniCssExtractPlugin({
      filename: ({chunk}) => {
        const dir = path.dirname(chunk.name); // Récupère le dossier du fichier SCSS
        const name = path.basename(chunk.name, '.scss'); // Nom du fichier sans extension .scss
        // Génère le fichier CSS dans le même dossier
        return path.join(dir, `${name}.css`);
      },
    }),
  ],
  resolve: {
    extensions: ['.scss'],
  },
  stats: 'errors-only',
};