(function ($, Drupal) {
  Drupal.behaviors.disableEmptySearch = {
    attach: function (context, settings) {
      const $form = $('#views-exposed-form-listing-view-actualites-listing', context);
      const $submit = $form.find('.filter-button');
      function toggleSubmit() {
        let hasInput = false;

          // Check if textfield is not empty
        const textValue = $form.find('#edit-actualites-title').val();
        console.log(textValue)
        if (textValue && textValue.trim() !== '') {
          hasInput = true;
        }

        // Check if select value is not the default "All" (i.e., empty)
        const selectValue = $form.find('select').val();
        console.log(selectValue)

        if ( selectValue !== 'All') {
          hasInput = true;
        }
                      console.log(hasInput) 

        // Enable or disable the submit button
        $submit.prop('disabled', !hasInput);
        
      }

      // Initial check
      toggleSubmit();

      // Check again when user types or selects
      $form.find('input, select').on('input change', toggleSubmit);
    }
  };
})(jQuery, Drupal);
