document.addEventListener('DOMContentLoaded', () => {
  const players = Plyr.setup('.plyr__video-embed', {
    controls: [],         // ✅ Pas de contrôles
    clickToPlay: true,
    autoplay: false,
    muted: false,
    autopause: false      // ❌ on gère manuellement
  });

  players.forEach((player, index) => {
    // Masquer les autres vidéos quand une démarre
    player.on('play', () => {
      players.forEach((otherPlayer, otherIndex) => {
        if (otherIndex !== index && typeof otherPlayer.pause === 'function') {
          otherPlayer.pause();
        }
      });

      // ✅ Masquer l’icône de lecture de cette carte
      const container = player.elements.container; // .plyr__video-embed
      const card = container.closest('.card4');
      if (card) {
        const icon = card.querySelector('.play-icon');
        if (icon) {
          icon.style.display = 'none';
        }
      }
    });
  });
});
